unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ImgList;

type
  TForm1 = class(TForm)
    Image: TImage;
    ImageList1: TImageList;
    OpenDialog: TOpenDialog;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    SaveDialog: TSaveDialog;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private

  public
	 procedure Save_screen();
	 procedure Clear_screen();
	 procedure Load_screen();
	 procedure Save_screen_2_file();
 end;


var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
	Save_screen();
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
   Clear_screen();
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
   Load_screen();
end;

procedure TForm1.Clear_screen();
begin
	Image.Picture.Assign(Nil);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	Application.Minimize();
   Save_screen();
   WindowState := wsMaximized;
end;

procedure TForm1.Load_screen();
var
	fName : String;

begin
   if OpenDialog.Execute() then
   begin
   	fName := OpenDialog.FileName;
      fName := AnsiUpperCase(fName);
   end;

   if Pos('BMP', fName) > 0 then
   begin
   	Image.Picture.LoadFromFile(fName);
   end;
end;

procedure TForm1.Save_screen_2_file();
var
	fName : String;

begin
   if SaveDialog.Execute() then
   begin
   	fName := SaveDialog.FileName;
      fName := AnsiUpperCase(fName);
   end;

   if Pos('BMP', fName) > 0 then
   begin
   	Image.Picture.SaveToFile(fName);
   end;
end;

procedure TForm1.Save_screen();
var
   bmp  : TBitmap;
   h    : HDC;

begin
   h   := GetDC(0);
   bmp := TBitmap.Create();

   bmp.Width  := Screen.Width;
   bmp.Height := Screen.Height;

   try
      BitBlt(bmp.Canvas.Handle, 0, 0, bmp.Width, bmp.Height, h, 0, 0, SRCCOPY);
      Image.Picture.Assign(bmp);
   finally
   	FreeAndNil(bmp);
      ReleaseDC(0, h);
   end;
end;

end.

